package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveDocBookReqDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import com.beiming.odr.document.dto.responsedto.SendDocBookResDTO;
import com.beiming.odr.document.enums.DocumentTypeEnum;

import java.util.Map;

/**
 * @author mayu
 * @date 2022/05/09
 */
public interface DocRecordSczcApi {

  /**
   * 获取笔录内容
   */
  DubboResult<DocRecordGetResDTO> viewClerkRecord(Long objectId, Long docId, Long meetingId, DocumentTypeEnum documentType, Map<String, Object> dataMap);

  /**
   * 编辑笔录后，保存笔录
   */
  void saveClerkRecord(Long docId, String content);

  /**
   * 在线编辑后发送笔录
   */
  DubboResult<SendDocBookResDTO> sendClerkRecordByDocId(SaveDocBookReqDTO reqDTO);

  /**
   * 笔录手写签名校验是否签名接口
   */
  DubboResult<Boolean> verifySignature(Long userId, Long documentId);

  /**
   * 本地文件上传发送笔录
   */
  DubboResult<SendDocBookResDTO> sendClerkRecordByFileId(SaveDocBookReqDTO reqDTO);
}
