package com.beiming.odr.document.api;

import java.util.List;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.DocTempSaveReqDTO;
import com.beiming.odr.document.dto.requestdto.DocTempShelveReqDTO;

/**
 * 
 * @ClassName: DocTempApi.java
 * @Description: 文书模板API
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月2日
 */
@Valid
public interface DocTemplateApi {

  /**
   * 文书模板保存编辑
   * 
   * @param saveReq
   * @return
   * @author djq
   * @date 2019年4月4日
   */
  DubboResult<Boolean> docTemplateSave(@Valid List<DocTempSaveReqDTO> saveReq);

  /**
   * 文书模板上下架状态处理
   * 
   * @param shelveReq
   * @return
   * @author djq
   * @date 2019年4月4日
   */
  DubboResult<Boolean> docTemplateShelve(@Valid DocTempShelveReqDTO shelveReq);

}
