package com.beiming.odr.document.api;

import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.document.dto.requestdto.DocTempSimpleListReqDTO;
import com.beiming.odr.document.dto.requestdto.DocTempSimpleSaveReqDTO;
import com.beiming.odr.document.dto.requestdto.DocTempSimpleShelveReqDTO;
import com.beiming.odr.document.dto.requestdto.IdReqDTO;
import com.beiming.odr.document.dto.responsedto.DocTempListResDTO;
import com.beiming.odr.document.dto.responsedto.DocTempSimpleResDTO;

/**
 * @ClassName DocTemplateSimpleApi
 * @Description 文书模板简版API
 * @author dongjunqing
 * @date Mar 8, 2020 7:24:54 PM
 *
 */
@Valid
public interface DocTemplateSimpleApi {

  /**
   * @Title docTemplateQuery
   * @Description 文书模版列表
   * @author dongjunqing
   * @param dto
   * @return PageInfo<DocTempListResDTO>
   */
  DubboResult<PageInfo<DocTempListResDTO>> docTemplateQuery(@Valid DocTempSimpleListReqDTO dto);

  /**
   * @Title docTemplateShelve
   * @Description 文书模板上下架状态处理
   * @author dongjunqing
   * @param shelveReq
   * @return DubboResult<Boolean>
   */
  DubboResult<Boolean> docTemplateShelve(@Valid DocTempSimpleShelveReqDTO shelveReq);

  /**
   * @Title docTemplateSave
   * @Description 文书模板保存编辑
   * @author dongjunqing
   * @param saveReq
   * @return DubboResult<Boolean>
   */
  DubboResult<Long> docTemplateSave(@Valid DocTempSimpleSaveReqDTO saveReq);

  /**
   * @Title docTemplateDelete
   * @Description 删除文书模版
   * @author dongjunqing
   * @param dto
   * @return DubboResult<Boolean>
   */
  DubboResult<Boolean> docTemplateDelete(@Valid IdReqDTO dto);

  /**
   * @Title docTemplateGet
   * @Description 获取文书模版
   * @author dongjunqing
   * @param dto
   * @return DubboResult<DocTempSimpleResDTO>
   */
  DubboResult<DocTempSimpleResDTO> docTemplateGet(@Valid IdReqDTO dto);

}
