package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SaveUndisputedFactReqDTO;
import com.beiming.odr.document.dto.responsedto.UndisputedFactResDTO;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 无争议事实 UNDISPUTED_FACT
 */
@Valid
public interface DocUndisputedFactApi {

  /**
   * 调解员获取无争议事实
   */
  DubboResult<UndisputedFactResDTO> getUndisputedFactByMediator(Long objId);

  /**
   * 用户获取无争议事实
   */
  DubboResult<UndisputedFactResDTO> getUndisputedFactByUser(Long objId);

  /**
   * 保存无争议事实
   */
  DubboResult<Long> saveUndisputedFact(SaveUndisputedFactReqDTO reqDTO);

}
