package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.ClerkConfirmReqDTO;
import com.beiming.odr.document.dto.requestdto.DocWholeConfirmReqDTO;
import com.beiming.odr.document.dto.requestdto.DocumentReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveDocBookReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveDocRequestDTO;
import com.beiming.odr.document.dto.responsedto.DocMaterialResDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.DocumentRecordResDTO;
import com.beiming.odr.document.dto.responsedto.DocumentResDTO;
import com.beiming.odr.document.dto.responsedto.SendDocBookResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * 文书列表
 *
 * @author qsh
 * @date 2019年6月20日
 */
public interface DocumentApi {

  /**
   * 查询文书列表
   *
   * @param dto
   * @return
   */
  DubboResult<ArrayList<DocumentResDTO>> queryDocumentList(DocumentReqDTO dto);

  /**
   * 查询文书确认列表
   *
   * @param dto
   * @return
   */
  DubboResult<ArrayList<DocWholeConfirmResDTO>> queryWholeConfirm(DocWholeConfirmReqDTO dto);

  /**
   * 根据文书id查询文书确认人
   */
  DubboResult<ArrayList<DocWholeConfirmResDTO>> queryWholeConfirmByDocId(Long docId);

  /**
   * 根据文书id查询文书信息
   */
  DubboResult<DocumentResDTO> queryDocumentByDocId(Long docId);

  /**
   * @descriptio 查询附件ID
   * @author YaWei Hu
   * @date 2020/7/9
   */
  DubboResult<String> queryFileId(String bizRoomId);

  DubboResult updateDocSignStatus(ClerkConfirmReqDTO clerkConfirmReq);

  DubboResult deleteDocBook(Long docId);

  /**
   * 根据会议id以及文书类型查询文书信息（广州仲裁查询文书对应盖章文书）
   */
  DubboResult<DocumentResDTO> queryDocumentByMeetingIdAndDocType(Long meetingId, String docType);

  /**
   * 发送在线送达中的文书
   */
  DubboResult<SendDocBookResDTO> gzzcuploadDocs(SaveDocBookReqDTO reqDTO);

  /**
   * 通过房间ids 请求文书记录。
   * 这个方法只能在互联网庭审中使用，其他系统切勿调用。
   */
  DubboResult<ArrayList<DocumentRecordResDTO>> queryDocumentByRoomIds(List roomIds);

  /**
   * 根据文件id查询文书
   */
  DubboResult<DocumentResDTO> queryDocumentByFileId(String fileId);
  DubboResult<Long> queryDocumentAttByfileId(String fileId);

  DubboResult<Long> insertJudicialDocument(SaveDocRequestDTO requestDTO);

  /**
   * 材料同步
   * @param requestDTO
   * @return
   */
  DubboResult<DocMaterialResDTO> insertMaterialDocument(SaveDocRequestDTO requestDTO);

  /**
   * 根据文书id 查询可下载的文书记录
   * @param ids
   * @return
   */
  DubboResult<ArrayList<DocumentResDTO>> queryDocumentByIds(List ids);
}
