package com.beiming.odr.document.api;


import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.GzzcBackoutDocSaveReqDTO;
import com.beiming.odr.document.dto.requestdto.GzzcDeliveryStatusRequestDTO;
import com.beiming.odr.document.dto.requestdto.SaveDocBookReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveDocSendLogReqDTO;
import com.beiming.odr.document.dto.responsedto.DocAttachmentResDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocSendLogResDTO;
import com.beiming.odr.document.dto.responsedto.GzzcDocDeliveryResDTO;
import com.beiming.odr.document.dto.responsedto.SendDocBookResDTO;
import java.util.ArrayList;

/**
 * 异步调解\在线送达相关
 *
 * @author 滑翔的人儿
 * @date 2022/01/11
 */
public interface GzzcAsyncMediationApi {

  /**
   * 撤诉模式下生成撤诉申请书
   */
  DubboResult<DocIdResDTO> generateBackoutApplyDoc(GzzcBackoutDocSaveReqDTO dto);

  /**
   * 盖章文书发送特殊处理
   */
  DubboResult<SendDocBookResDTO> sendStampDoc(SaveDocBookReqDTO reqDTO);

  /**
   * 修改文书发送状态
   */
  DubboResult<SendDocBookResDTO> updateDocSendStatus(SaveDocBookReqDTO reqDTO);

  /**
   * 发送在线送达中的文书
   */
  DubboResult<SendDocBookResDTO> sendOnlineDeliveryDoc(SaveDocBookReqDTO reqDTO);

  /**
   * 更新文书送达状态，异步调解和在线送达都可用
   */
  void updateDocDeliveryStatus(GzzcDeliveryStatusRequestDTO reqDto);

  /**
   * 根据文书id获取文书送达状态
   */
  DubboResult<ArrayList<GzzcDocDeliveryResDTO>> getDocDeliveryStatus(Long docId);

  /**
   * 获取用户在线送达文书列表
   */
  DubboResult<ArrayList<DocAttachmentResDTO>> queryUserOnlineDocList(Long meetingId, Long userId);

  /**
   * 根据文书id修改文书fileId
   */
  void updateFileIdByDocId(Long docId, String fileId);

  /**
   * 保存文书发送到邮箱和手机记录
   */
  void saveDocSendLog(SaveDocSendLogReqDTO reqDTO);

  /**
   * 查询某个文书的发送记录
   */
  DubboResult<ArrayList<DocSendLogResDTO>> querySendLogByDocIdAndObjId(Long docId, Long objectId);
}
