package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.MediateWorkbenchGetReqDTO;
import com.beiming.odr.document.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.document.dto.responsedto.MediateWorkbenchGetResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 调解附加信息API
 */
@Valid
public interface MediateAdditionalInfoApi {

  /**
   * 获取案件文书材料
   */
  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(Long lawCaseId);

  /**
   * 获取文书材料
   */
  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(Long objectId,
      String objectType);

  /**
   * 获取工作台信息
   */
  DubboResult<ArrayList<MediateWorkbenchGetResDTO>> getMediationWorkbench(
      MediateWorkbenchGetReqDTO reqDTO);

}
