package com.beiming.odr.document.api;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.dto.requestdto.UserInfoReqDTO;

/**
 * Created by lh on 2020/6/12.
 *
 * 笔录线下签字
 */
@Valid
public interface OfflineApi {

  /**
   * 笔录线下签字
   *
   * @param docId 文书id
   * @param user 操作者
   */
  DubboResult offlineDocument(
      @Valid @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL) Long docId,
      @Valid UserInfoReqDTO user);
  
  /**
   * 修改签名状态为重签
   * @param docId
   * @param userId
   * @return
   */
  DubboResult signAgainDocument(@Valid @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL) Long docId,
      @Valid @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL) Long userId,
      String userName);
}
