package com.beiming.odr.document.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.document.dto.requestdto.SignatureInfoReqDTO;
import com.beiming.odr.document.dto.requestdto.SignatureInfoWithFileReqDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureInfoResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * Created by zli on 2019/2/22.
 *
 * 签名
 */
@Valid
public interface SignatureApi {

  /**
   * <pre>
   * 确认签名<br>
   * 不涉及业务主体操作（业务对象：案件、进度以及短信的逻辑处理）<br>
   * 可根据返回结果进行处理业务主体操作
   */
  DubboResult<SignatureInfoResDTO> confirmSignature(@Valid SignatureInfoReqDTO reqDTO);

  /**
   * 电子送达回证确认签名
   */
  DubboResult<SignatureInfoResDTO> signElectronicDoc(@Valid SignatureInfoReqDTO reqDTO);
  

  /**
   * <pre>
   * 确认签名(JSON字符串)<br>
   * 不涉及业务主体操作（业务对象：案件、进度以及短信的逻辑处理）<br>
   * 可根据返回结果进行处理业务主体操作
   */
  DubboResult<SignatureInfoResDTO> confirmSignatureWithJsonStr(String signatureInfoReqDTO);

  /**
   * <pre>
   * 确认签名(带文件)<br>
   * 不涉及业务主体操作（业务对象：案件、进度以及短信的逻辑处理）<br>
   * 可根据返回结果进行处理业务主体操作
   */
  DubboResult<SignatureInfoResDTO> confirmSignatureWithFile(
      @Valid SignatureInfoWithFileReqDTO reqDTO);

  /**
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<DocWholeConfirmResDTO>> queryBilu(Long meetId, Long userId, Long docId);

  /**
   * <pre>
   * 重签确认签名<br>
   * 不涉及业务主体操作（业务对象：案件、进度以及短信的逻辑处理）<br>
   * 可根据返回结果进行处理业务主体操作
   */
  DubboResult<SignatureInfoResDTO> confirmSignatures(@Valid SignatureInfoReqDTO reqDTOs);


  /**
   * 修改签名状态
   * @param id
   * @param confirm
   * @param confirmTime
   * @param version
   * @return
   */
  DubboResult updateConfirm(DocWholeConfirmResDTO ss);

  DubboResult<DocWholeConfirmResDTO> queryR(DocWholeConfirmResDTO ss);

  DubboResult<DocWholeConfirmResDTO> queryState(Long docId);

}
