package com.beiming.odr.document.dto;

import com.beiming.odr.document.dto.requestdto.SignatureBizInfoReqDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 对文书发表意见（签名，拒绝）后的业务信息
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ClerkBizInfoDTO implements Serializable {

  private static final long serialVersionUID = -1057959836990248318L;

  // === === 文书相关信息 === ===
  /**
   * 文书ID
   */
  private Long docId;
  /**
   * 文书名称
   */
  private String docName;
  /**
   * 文书类型
   */
  private String docType;
  /**
   * 文书原始确认状态
   */
  private String docOriginConfirm;
  /**
   * 需要置为失效的文书ID（进度内文书所对应的旧进度处理）
   */
  private Long docIdDisable;

  // === === 会议相关信息 === ===
  /**
   * 会议ID
   */
  private Long meetId;

  // === === 业务主体相关信息 === ===
  /**
   * 业务主体ID
   */
  private Long bizId;
  /**
   * 业务主体的编号（注意：不是文书里的编号）
   */
  private String bizNo;
  /**
   * 业务主体类型
   */
  private String bizType;
  /**
   * 业务主体的纠纷类型（注意：不是文书里的纠纷类型）
   */
  private String bizDisputeType;
  /**
   * 业务主体的短信开关
   */
  private String bizMsgSwitch;

  // === === 用户相关信息 === ===
  /**
   * 用户ID
   */
  private Long userId;
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户类型(调解员，申请人，当事人等)
   */
  private String userType; // caseUserType
  /**
   * 确认人Ids
   */
  private String confirmIds;

  // === === 文书人员信息 === ===

  private List<ClerkPersonnel> clerkPersonnel;

  // === === 业务主体附加相关信息 === ===
  /**
   * 是否取消后续动作
   */
  private Boolean cancel = false;
  /**
   * 是否角色用户最后一个
   */
  private Boolean isTypeLast = false;
  /**
   * 是否全用户最后一个
   */
  private Boolean isAllLast = false;

  /**
   * 带参构造函数
   * 
   * @param docId
   * @param docName
   * @param docType
   * @param meetId
   * @param bizId
   * @param bizType
   * @param userId
   * @param userName
   * @param caseUserType
   */
  public ClerkBizInfoDTO(Long docId, String docName, String docType, Long meetId, Long bizId,
      String bizType, Long userId, String userName, String userType) {
    super();
    this.docId = docId;
    this.docName = docName;
    this.docType = docType;
    this.meetId = meetId;
    this.bizId = bizId;
    this.bizType = bizType;
    this.userId = userId;
    this.userName = userName;
    this.userType = userType;
  }

  /**
   * 补充业务信息
   * 
   * @param signBizInfo
   */
  public void addBizInfo(SignatureBizInfoReqDTO signBizInfo) {
    this.setBizNo(signBizInfo.getBizNo());
    this.setBizDisputeType(signBizInfo.getBizDisputeType());
    this.setBizMsgSwitch(signBizInfo.getMsgSwitch());
  }

  public List<ClerkPersonnel> queryClerkPersonnelByCaseUserType(String caseUserType) {
    List<ClerkPersonnel> result = new ArrayList<ClerkPersonnel>();

    if (Objects.nonNull(caseUserType)) {
      for (ClerkPersonnel clerkPer : clerkPersonnel) {
        if (caseUserType.equalsIgnoreCase(clerkPer.getCaseUserType())) {
          result.add(clerkPer);
        }
      }
    }
    return result;
  }


}
