package com.beiming.odr.document.dto;

import com.beiming.framework.message.BaseMessageDto;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 对文书发表意见（签名，拒绝）后的业务信息
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class ClerkBizInfoMqDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 1954274711824695270L;

  /**
   * 业务主键，防止重复消费消息
   */
  private String bizKey;

  /**
   * 重试次数
   */
  private Integer retryTimes;

  /**
   * 文书确认动作类型
   * 
   * @see DocSignStatusEnum
   */
  private String docSignStatus; // 同意 或者 拒绝

  /**
   * 产生时间
   */
  private Date createTime; // 写业务进度需要此数据

  /**
   * 用户确认信息
   */
  private List<ClerkBizInfoDTO> clerkBizInfos;

}
