package com.beiming.odr.document.dto;

import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.DocPersonalReqDTO;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2019/2/25.
 *
 * 文书人员
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ClerkPersonnel implements Serializable {

  private static final long serialVersionUID = 8583264555571327519L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（申请人 ,被申请人, 调解员）
   */
  private String caseUserType;

  /**
   * 用户类型（自然人,法人,非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 省code
   */
  private String provCode;

  /**
   * 市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省名称
   */
  private String provName;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 用户注册来源
   */
  private String userRegisterOrigin;

  /**
   * 固定电话
   */
  private String telephone;

  /**
   * 送达地址确认书
   */
  private String docAddress;

  /**
   * 材料id
   */
  private Long lawAttachmentId;

  /**
   * 代理了谁
   */
  private Long agentParentId;

  /**
   * 不对ID类设值Id、ObjectId、DocId
   */
  public ClerkPersonnel(DocPersonalReqDTO docPerReq) {

    this.setUserId(docPerReq.getUserId());
    this.setUserName(docPerReq.getName());
    this.setUserType(docPerReq.getUserType());
    this.setCaseUserType(docPerReq.getCaseUserType());
    this.setAgentParentId(docPerReq.getAgentParentId());
    this.setPhone(docPerReq.getPhone());

    this.setSex(docPerReq.getSex());
    this.setIdCard(docPerReq.getIdCard());
    this.setProvCode(docPerReq.getProvCode());
    this.setCityCode(docPerReq.getCityCode());
    this.setAreaCode(docPerReq.getAreaCode());
    this.setStreetCode(docPerReq.getStreetCode());
    this.setProvName(docPerReq.getProvName());
    this.setCityName(docPerReq.getCityName());
    this.setAreaName(docPerReq.getAreaName());
    this.setStreetName(docPerReq.getStreetName());
    this.setAddress(docPerReq.getAddress());
    this.setCorporation(docPerReq.getCorporation());
  }

  /**
   * 文书人员
   */
  public ClerkPersonnel(DocPersonReqDTO docPerson) {
    this.setUserId(docPerson.getUserId());
    this.setUserName(docPerson.getUserName());
    this.setUserType(docPerson.getUserType());
    this.setCaseUserType(docPerson.getCaseUserType());
    this.setPhone(docPerson.getPhone());
    this.setSex(docPerson.getSex());
    this.setIdCard(docPerson.getIdCard());
    this.setProvCode(docPerson.getProvCode());
    this.setCityCode(docPerson.getCityCode());
    this.setAreaCode(docPerson.getAreaCode());
    this.setStreetCode(docPerson.getStreetCode());
    this.setProvName(docPerson.getProvName());
    this.setCityName(docPerson.getCityName());
    this.setAreaName(docPerson.getAreaName());
    this.setStreetName(docPerson.getStreetName());
    this.setAddress(docPerson.getAddress());
    this.setCorporation(docPerson.getCorporation());
    this.setCreditCode(docPerson.getCreditCode());
    this.setUserOrder(docPerson.getUserOrder());
  }

}
