package com.beiming.odr.document.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文书模板上线内容实体类
 * 
 * @ClassName: DocTempOrgDTO.java
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月2日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocTempOnlineDTO implements Serializable {

  private static final long serialVersionUID = 2258378270197217262L;

  /**
   * 文书模板ID
   */
  private Long docId;
  /**
   * 文书模板类型
   */
  private String docType;

  /**
   * 文书模板名称
   */
  private String docName;

  /**
   * 模板内容
   */
  private String docContent;
  
  /**
   * 文书适用用户类型
   */
  private String docUserType;

  /**
   * 字典代码
   */
  private String bizCode;

  /**
   * 应用模块状态
   */
  private String applicationModuleCode;

  /**
   * 父类ID
   */
  private Long parentId;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 租户模板：0未使用1上架2下架
   */
  private Integer onlineStatus;

  /**
   * 机构模板：0未使用1上架2下架
   */
  private Integer subOnlineStatus;

}
