package com.beiming.odr.document.dto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * @ClassName DocTempSignDTO
 * @Description 文书模板签名信息
 * @author dongjunqing
 * @date Mar 8, 2020 7:34:51 PM
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocTempSignDTO implements Serializable {

  private static final long serialVersionUID = 2258378270197217262L;

  @NotBlank(message = "签名的标识不能为空")
  private String signMark;

  @NotBlank(message = "签名的用户类型不能为空")
  private String userType;
  
  @NotBlank(message = "签名标识的顺序不能为空")
  private Integer signOrder;

}
