package com.beiming.odr.document.dto;

import com.beiming.framework.message.BaseMessageDto;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 对接报告mq
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class DockingDocMqDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 1954274711824695270L;

  /**
   * 业务主键，防止重复消费消息 objectId.time
   */
  private String bizKey;

  /**
   * 重试次数
   */
  private Integer retryTimes;

  /**
   * 第三方全拼缩写
   */
  private String thirdName;


  /**
   * 第三方提供访问地址
   */
  private String url;

  /**
   * 第三方提供访问接口方法 POST/GET
   */
  private String method;
  /**
   * 第三方接口 入参（消费记录中使用，最外层不用添加）
   */
  private String params;
  /**
   * 案件id
   */
  private Long objectId;

  /**
   * 案件关闭产生时间
   */
  private Date createTime; // 写业务进度需要此数据

  /**
   * 调用逻辑service标记位
   */
  private String sign;


  /**
   * MQ是否消费  SIGN_NO/SIGN_YES
   */
  private String confirm;
}
