package com.beiming.odr.document.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 文书相关人
 * @Author: caiwei
 * @Date: Created 2018-07-07
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DocumentPersonnelDTO implements Serializable {

  private static final long serialVersionUID = -342962860170190171L;

  /**
   * 用户类型
   */
  private String userType;

  /**
   * 用户案件类型名称（申请人，被申请人）
   */
  private String title;

  /**
   * 用户姓名
   */
  private String actualName;
  
  /**
   * 手机号
   */
  private String phone;

  /**
   * 地址
   */
  private String address;

  /**
   * 机构代表人、法人代表人名称
   */
  private String corporation;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 性别
   */
  private String sex;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 民族
   */
  private String nation;

  /**
   * 生日
   */
  private String birthday;

  /**
   * 代理人名称
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;

  /**
   * 代理人手机号
   */
  private String agentPhone;

  /**
   * 代理人单位
   */
  private String company;

  /**
   * 用户排序
   */
  private Integer userOrder;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 调解请求
   */
  private String claimForArbitration;
}
