package com.beiming.odr.document.dto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.message.BaseMessageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 文档图像合成后的业务信息
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class SyntheticDocBizInfoMqDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 1954274711824695270L;

  /**
   * 业务主键，防止重复消费消息
   */
  private String bizKey;

  /**
   * 重试次数
   */
  private Integer retryTimes;

  /**
   * 用户确认信息
   */
  private List<SignatureBizInfoDTO> signatureBizInfos;

}
