package com.beiming.odr.document.dto;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.exception.DubboBusinessException;
import com.beiming.framework.message.BaseMessageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 文档图像合成
 * 
 * @author djq
 *
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class SyntheticDocumentMqDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 1954274711824695270L;

  /**
   * 业务主键，防止重复消费消息
   */
  private String bizKey;

  /**
   * 重试次数
   */
  private Integer retryTimes;

  /**
   * 确认人用户Id
   */
  private Long userId;

  /**
   * 确认人用户Name
   */
  private String userName;

  /**
   * 确认人案件用户Type
   */
  private String caseUserType;

  /**
   * 文档ID
   */
  private Long documentId;

  /**
   * 合成图像ID
   */
  private String signatureImageId;

  /**
   * 用户确认信息
   */
  private List<SyntheticConfirmsDTO> syntheticConfirms;

  public SyntheticDocumentMqDTO(Long userId, String userName, String caseUserType, Long documentId,
      String signatureImageId) {
    super();
    checkBasicInfoValid(userId, userName, caseUserType, documentId, signatureImageId);
    this.userId = userId;
    this.userName = userName;
    this.caseUserType = caseUserType;
    this.documentId = documentId;
    this.signatureImageId = signatureImageId;
  }

  public SyntheticDocumentMqDTO(Long userId, String userName, String caseUserType, Long documentId,
      String signatureImageId, List<SyntheticConfirmsDTO> syntheticConfirms) {
    super();
    checkBasicInfoValid(userId, userName, caseUserType, documentId, signatureImageId);
    this.userId = userId;
    this.userName = userName;
    this.caseUserType = caseUserType;
    this.documentId = documentId;
    this.signatureImageId = signatureImageId;
    this.syntheticConfirms = syntheticConfirms;
  }

  private void checkBasicInfoValid(Long userId, String userName, String caseUserType,
      Long documentId, String signatureImageId) {
    if (null == documentId || documentId.equals(0L)) {
      throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR, "传输的消息文书标识不能为空");
    }
    if (null == userId || userId.equals(0L)) {
      throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR, "传输的消息用户标识不能为空");
    }
    if (StringUtils.isEmpty(signatureImageId)) {
      throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR, "传输的消息图像标识不能为空");
    }
    if (StringUtils.isEmpty(userName)) {
      // throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR, "传输的消息用户名称不能为空");
    }
    if (StringUtils.isEmpty(caseUserType)) {
      throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR, "传输的消息用户类型不能为空");
    }
  }

}
