package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.enums.CategoryBigTypeEnum;
import com.beiming.odr.document.enums.CategoryMiddleTypeEnum;

/**
 * 
 * @author qsh
 * @date 2019年2月27日
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
public class AttachmentListReqDTO extends ObjectReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long userId;
  /**
   * 在线庭审ID
   */
  private Long meetingId;

  /**
   * 附件大分类枚举类
   * @see CategoryBigTypeEnum
   */
  private String categoryBigTypeEnum;

  /**
   * 附件中分类枚举类
   * @see CategoryMiddleTypeEnum
   */
  private String categoryMiddleTypeEnum;

}
