package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.DocumentValidateMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 通过附件id 更新roomId
 * @author jimmy
 * @date 2020-02-05
 */
@Data
@NoArgsConstructor
public class AttachmentRoomIdReqDTO  implements Serializable {

  private static final long serialVersionUID = 1L;



  /**
   * 更新人
   */
  @NotBlank(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  private String operUserName;

  /**
   * 附件id
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long id;

  /**
   * 房间id
   */
  @NotBlank(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  private String roomId;

}
