package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 查询某用户对调解文书的签名状态请求参数
 *
 * @author DJQ 2018年6月27日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClerkConfirmPerReqDTO implements Serializable {

  private static final long serialVersionUID = -3717803688994585053L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;

  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long lawCaseId;

  @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL)
  private Long documentId;

  private String userType;

}
