package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Data;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 附件删除
 * 
 */
@Data
public class DelFileByFileIdReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 附件id
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long attachId;
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long caseId;
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_FILE_ID_NULL)
  private String fileId;
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;
  
  
}
