package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: sunzheng
 * @Description: 查询电子送达签署情况
 * @Date: Created 2023-07-03 18:10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeliveryRequestDTO implements Serializable {


  private static final long serialVersionUID = -2007534296827646871L;

  @NotNull(message = "会议ID不能为空")
  private Long meetingId;

  private Long userId;

  private Integer status;


  public DeliveryRequestDTO(Long meetingId) {
    this.meetingId = meetingId;
  }

  public DeliveryRequestDTO(Long meetingId, Integer status) {
    this.meetingId = meetingId;
    this.status = status;
  }
}
