package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.ObjectTypeEnum;

/**
 * 获取异议书的请求对象
 * 
 * @author DJQ
 *
 */
@Data
public class DocDissentGetReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long bizId;

  /**
   * @see ObjectTypeEnum
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_TYPE_NULL)
  private String bizType;
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_MEDIATION_SCHEME_ID_NULL)
  private Long mediationSchemeId; // 调解方案ID
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;

}
