package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 保存异议书的请求对象
 * 
 * @author DJQ 2018年7月8日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DocDissentSaveReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long bizId; // 业务主体ID：案件号
  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_TYPE_NULL)
  private String bizType; // 业务主体类型
  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;
  @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_MEDIATION_SCHEME_ID_NULL)
  private Long mediationSchemeId; // 调解方案ID
  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_TYPE_NULL)
  private String userType; // 用户类型

  private Long docId;
  private String userName; // 用户名称
  private String caseUserType; // 用户案件角色
  private String sex; // 性别
  private String phone; // 电话号
  private String idCard; // 身份证号
  private String provCode; // 省Code
  private String cityCode; // 市Code
  private String areaCode; // 区Code
  private String streetCode; // 街道Code
  private String provName; // 省Name
  private String cityName; // 市Name
  private String areaName; // 区Name
  private String streetName; // 街Name
  private String address; // 地址
  private String content; // 文本内容

}
