package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import lombok.Data;

/**
 * 文书相关人员信息
 * 
 * @author DJQ
 *
 */
@Data
public class DocPersonalReqDTO implements Serializable {

  private static final long serialVersionUID = 743850531444861084L;

  /**
   * id
   */
  private Long id;

  /**
   * 案件号
   */
  private String caseNo;

  /**
   * 案件id
   */
  private Long objectId;

  /**
   * 案件文书id
   */
  private Long docId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;
  
  /**
   * 代理了谁
   */
  private Long agentParentId;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String name;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;
  
  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 固话
   */
  private String telephone;
  
  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

}
