package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Data;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.ObjectTypeEnum;

/**
 * 获取笔录的请求对象
 *
 * @author DJQ
 */
@Data
public class DocRecordGetReqDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long bizId;
  
  /**
   * @see ObjectTypeEnum
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_TYPE_NULL)
  private String bizType;
  
  /**
   * 文书ID
   */
  private Long docId;
  
  /**
   * 会议相关信息
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_MEET_ID_NULL)
  private Long meetingId;
  
  /**
   * 笔录类型（根据会议类型判断 @see ）
   * @see MeetingOrderEnum
   */
  private String meetingOrderType;

  private String meetingOrderAddress;
  
  private String meetingJoinUserIds;
  
  private String meetingVideoId;
  
  private String roomId;
  
  /**
   * 业务主体相关信息
   */
  String disputeType;
  Long orgId;
  String orgName;
  
  /**
   * 人员相关信息
   */
  List<DocPersonalReqDTO>  docPersonalLst;

}
