package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.DocumentValidateMessage;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 保存笔录的请求对象
 * 
 * @author djq
 *
 */
@Data
public class DocRecordSaveReqDTO implements Serializable {

  private static final long serialVersionUID = -4199123392944350393L;
  
  @NotNull(message = DocumentValidateMessage.PARAMETER_MEET_ID_NULL)
  private Long meetingId;
  @NotNull(message = DocumentValidateMessage.PARAMETER_MEET_ODER_NULL)
  private Integer meetingOrder; // 会议顺序
  private String meetingOrderType;
  private String meetingJoinUserIds;
  
  private Long docId;
  private String content; // 笔录内容
  private String mediatorName; // 调解员姓名
  private String location; // 地点
  private String time; // 时间
  // @NotNull(message = DocumentValidateMessage.DOCUMENT_REMARK_NULL)
  private String remark; // 备注
  
  private Long bizId;
  private String bizType;
  private String bizNo; // 案件号
  private String disputeType; // 纠纷类型
  private Long orgId; //机构ID
  private String orgName; //机构名称
  
  private List<DocPersonalReqDTO> docPersonalLst; // 文书参与人信息
  
  /**
   * 创建人
   */
  private String createUser;
  /**
   * 创建人id
   */
  private Long createUserId;

  /**
   * 文件名称
   */
  private String fileName;

  /**
   * 用户信息  原告-张三-身份证... 微庭审使用
   */
  private String userInfo;

  /**
   * 选中的用户personId 微庭审使用
   */
  private List<Long> selectPersonIds;
  
  /**
   * 房间id 微庭审使用
   */
  private String roomId;


  /**
   * 是否是会议中新添加用户了
   */
  private boolean isAddUser = false;

}
