package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.DocumentValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 文书签名列表请求<br> 工作台
 *
 * @author djq
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocSignListReqDTO implements Serializable {

  private static final long serialVersionUID = -2857007135154160717L;

  /**
   * 业务主体ID
   */
//  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long bizId;

  /**
   * 会议id
   */
  private Long meetId;

  /**
   * 会议父id
   */
  private Long parentId;
  /**
   * 业务主体类型
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_TYPE_NULL)
  @Min(value = 1, message = "值非法")
  private String bizType;
  /**
   * 用户ID
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long userId;

}
