package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.dto.DocTempOrgDTO;

/**
 * 文书模板请求信息
 * 
 * @ClassName: DocTempInfoReqDTO.java
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月2日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocTempSaveReqDTO implements Serializable {

  private static final long serialVersionUID = -2857007135154160717L;

  @NotNull(message = "文书模板ID不能为空")
  @Min(value = 1, message = "值非法")
  private Long docId;

  @NotNull(message = "文书模板是否启用标识不能为空")
  private Integer onlineStatus;

  @NotNull(message = "业务类型ID不能为空")
  @Min(value = 1, message = "值非法")
  private Long bizId;

  @NotBlank(message = "业务类型Code不能为空")
  private String bizCode;

  @NotBlank(message = "业务类型Name不能为空")
  private String bizName;

  @NotBlank(message = "文书模板类型不能为空")
  private String docType;

  @NotBlank(message = "文书模板名称不能为空")
  private String docName;

  @NotBlank(message = "文书模板内容不能为空")
  private String docContent;

  // @ApiModelProperty(value = "应用用户类型", required = false,
  // notes = "PERSONAL(个人)" + "COMPANY(法人或非法人组织)")
  private String docUserType;

  // @NotBlank(message = "应用模块Code不能为空")
  private String appModuleCode;

  // @NotBlank(message = "应用模块名称不能为空")
  private String appModuleName;

  // Strat

  // 文书下发模板ID,基础模板下发时需有值\
  private Long parentDocId;

  @NotBlank(message = "租户标识不能为空")
  private String platformCode;

  @NotBlank(message = "租户标识不能为空")
  private String platformName;

  // @NotEmpty(message = "机构ID串不能为空")
  private List<DocTempOrgDTO> docTempOrgs;

}
