package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 文书模板上下架请求参数
 * @ClassName: DocTempShelveRequestDTO.java
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月2日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DocTempShelveReqDTO implements Serializable {

  private static final long serialVersionUID = 5002849896886191277L;

  @NotBlank(message = "租户标识不能为空")
  private String platformCode;
  
  @NotNull(message = "文书模板ID不能为空")
  private Long docId;

  @NotNull(message = "文书模板是否启用标识不能为空")
  private Integer onlineStatus;

  private Long orgId; // 机构模板操作时有值

}