package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.odr.document.dto.DocTempSignDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ClassName DocTempSimpleSaveReqDTO
 * @Description 文书模板请求信息
 * @author dongjunqing
 * @date Mar 8, 2020 7:31:53 PM
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocTempSimpleSaveReqDTO implements Serializable {

  private static final long serialVersionUID = -2857007135154160717L;

  private Long docTempId;

  @NotNull(message = "文书模板是否启用标识不能为空")
  private Integer onlineStatus;

  @NotBlank(message = "文书模板类型不能为空")
  private String docType;

  @NotBlank(message = "文书模板名称不能为空")
  private String docName;

  // @NotBlank(message = "文书模板内容不能为空")
  private String docContent;

  /**
   * 操作人ID
   */
  private Long userId;

  /**
   * 操作人姓名
   */
  private String userName;
  
  /**
   * 下载标识
   */
  private Boolean downloadFlag;

  // @NotEmpty(message = "签名标识信息不能为空")
  private List<DocTempSignDTO> docSigns;

}
