package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @ClassName DocTempSimpleShelveReqDTO
 * @Description 文书模板上下架请求参数
 * @author dongjunqing
 * @date Mar 9, 2020 12:15:29 AM
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class DocTempSimpleShelveReqDTO implements Serializable {

  private static final long serialVersionUID = 5002849896886191277L;

  @NotNull(message = "文书模板ID不能为空")
  private Long id;

  @NotNull(message = "文书模板是否启用标识不能为空")
  private Integer onlineStatus;

}
