package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.dto.DocumentPersonnelDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Data;

/**
 * 广州仲裁撤诉模式下文书保存请求参数
 */
@Data
public class GzzcBackoutDocSaveReqDTO implements Serializable {

  private static final long serialVersionUID = -4199123392944350393L;


  /**
   * 更新时间
   */
  private Date updateTime;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 创建人姓名
   */
  private String createUser;

  /**
   * 更新人姓名
   */
  private String updateUser;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 文书类型（无争议事实承诺书,无异议调解方案,调解协议书,调解笔录）
   */
  private String docType;

  /**
   * 文档名称
   */
  private String docName;

  /**
   * 文件id
   */
  private String fileId;

  /**
   * 是否已发送
   */
  private String sendStatus;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 组织机构名字
   */
  private String orgName;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 会议ID
   */
  private Long meetingId;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 模板id
   */
  private Long docTempId;

  /**
   * 房间id
   */
  private String roomId;

  /*以上为保存文书所用字段，以下是生成文书所需字段*/

  /**
   * 申请人
   */
  private List<DocumentPersonnelDTO> applicantList;

  /**
   * 被申请人
   */
  private List<DocumentPersonnelDTO> respondentList;

  /**
   * 案件开始时间
   */
  private String applyTime;

  /**
   * 撤诉申请时间
   */
  private Date backTime;

  /**
   * 仲裁员
   */
  private String arbitrator;

  /**
   * 书记员
   */
  private String clerk;

  /**
   * 撤诉理由
   */
  private String reason;

  /**
   * 文书送达信息
   */
  private List<Map<String, String>> deliveryInfoList;

  private String applicanSignTime;

  private String respondentSignTime;
}
