package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.dto.DocumentPersonnelDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 调解书
 */
@Data
public class GzzcMediationDocReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 文书类型（无争议事实承诺书,无异议调解方案,调解协议书,调解笔录）
   */
  private String docType;

  /**
   * 文档名称
   */
  private String docName;

  /**
   * 组织机构名字
   */
  private String orgName;

  /**
   * 机构id
   */
  private Long orgId;


  /**
   * 房间id
   */
  private String roomId;

  /**
   * 案件id
   */
  private Long caseId; //

  /**
   * 会议id
   */
  private Long meetingId;

  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /**
   * 调解条件
   */
  private List<String> mediationConditions;

  /**
   * 申请人信息
   */
  private List<DocumentPersonnelDTO> applicantList;

  /**
   * 被申请人信息
   */
  private List<DocumentPersonnelDTO> respondentList;

  /**
   * 申请人代理人
   */
  private List<DocumentPersonnelDTO> appAgentList;

  /**
   * 被申请人代理人
   */
  private List<DocumentPersonnelDTO> resAgentList;

  /**
   * 仲裁员
   */
  private String arbitrator;

  /**
   * 书记员
   */
  private String clerk;

  /**
   * 仲裁请求
   */
  private String appeal;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 调解时间
   */
  private Date mediationTime;

  /**
   * 调解地点
   */
  private String mediationLocation;

  /**
   * 调解记录
   */
  private String mediationRecords;

  /**
   * 受送达人
   */
  private String addressee;

  /**
   * 送达人
   */
  private String sendPerson;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;


  private String applicanSignTime;

  private String respondentSignTime;

  /**
   * 案由
   */
  private String causeName;

  /**
   * 调解号
   */
  private String mediateCase;

  /**
   * 调解员
   */
  private String mediator;
}
