package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * Created by zli on 2019/2/22.
 *
 * 主键Id
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IdReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 文书ID
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long id;
}
