package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 工作台的请求对象
 *
 * @author djq
 */
@Data
public class MediateWorkbenchGetReqDTO implements Serializable {

  private static final long serialVersionUID = -4199123392944350393L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long bizId;

  private Long userId;

  /**
   * true：用户签名后不显示文书|false：必须显示已发送文书
   */
  private Boolean workbenchModel;

  private List<DocPersonalReqDTO> docPersonalLst; // 文书参与人信息

}
