package com.beiming.odr.document.dto.requestdto;

import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2019/2/22.
 *
 * 分类信息
 */
@SuppressWarnings("serial")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ObjectBizRoomReqDTO implements Serializable {

  private Long objectId;

  private Long bizRoomId;
  private ArrayList<Long> meetingIds;

  private Long meetingId;

  private Long userId;
  /**
   * @see ObjectTypeEnum
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_IS_NULL)
  private String objectType;
  public ObjectBizRoomReqDTO(@NotNull(message = "ID参数为空") @Min(value = 1, message = "值非法") Long objectId,
      @NotNull(message = "传入参数为空") String objectType) {
    super();
    this.objectId = objectId;
    this.objectType = objectType;
  }

}
