package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lh
 * @Date 2020年6月16日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ObjectMicroReqDTO implements Serializable {

  private static final long serialVersionUID = -7654265514049583759L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long objectId;

  private Long meetingId;
  /**
   * @see ObjectTypeEnum
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_IS_NULL)
  private String objectType;

  private String roomId;

  public ObjectMicroReqDTO(
      @NotNull(message = "ID参数为空") @Min(value = 1, message = "值非法") Long objectId,
      @NotNull(message = "传入参数为空") String objectType, String roomId) {
    super();
    this.objectId = objectId;
    this.objectType = objectType;
    this.roomId = roomId;
  }

}


