package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.ObjectTypeEnum;

/**
 * Created by zli on 2019/2/22.
 *
 * 分类信息
 */
@SuppressWarnings("serial")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ObjectReqDTO implements Serializable {

  @NotNull(message = DocumentValidateMessage.PARAMETER_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long objectId;

  private String flag;

  private Long meetingId;
  
  private Long userId;
  /**
   * @see ObjectTypeEnum
   */
  @NotNull(message = DocumentValidateMessage.PARAMETER_IS_NULL)
  private String objectType;
  public ObjectReqDTO(@NotNull(message = "ID参数为空") @Min(value = 1, message = "值非法") Long objectId,
      @NotNull(message = "传入参数为空") String objectType) {
    super();
    this.objectId = objectId;
    this.objectType = objectType;
  }

}
