package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存文书请求参数
 * @Author: caiwei
 * @Date: 2019/3/1
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PushRecordReqDTO implements Serializable {

  private static final long serialVersionUID = 6954300512268481649L;

  /**
   * 文件id
   */
  private Long docId;

  /**
   * 排期和案件空间id
   */
  private Long objectId;

  /**
   * 案件id
   */
  private Long bizId;

  /**
   * 所属法院
   */
  private String fydm;

  /**
   * 所属法院名称
   */
  private String fymc;

  /**
   * 调用方法
   */
  private String method;

  /**
   * 调用路径
   */
  private String url;

  /**
   * 对第三方名称
   */
  private String thirdName;

  /**
   * 调用参数
   */
  private String params;

  /**
   *创建时间
   */
  private Date createTime;



  /**
   * 对接枚举标记位
   */
  private String sign;

  /**
   * 对接请求参数
   */
  private String appName;





}