package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存文书请求参数
 * @Author: caiwei
 * @Date: 2019/3/1
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SaveDocBookReqDTO implements Serializable {

  private static final long serialVersionUID = 6954300512268481649L;

  /**
   * 文书id
   */
  private Long docId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 文书类型
   */
  private String docType;

  /**
   * 文书类型
   */
  private String docName;

  /**
   * 会议id
   */
  private Long meetingId;

  /**
   * 编号
   */
  private String caseNo;
  
  /**
   * 机构Id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 仲裁协议书人员
   */
  private List<DocPersonReqDTO> personList;

  /**
   * 协议内容
   */
  private String content;

  /**
   * 创建者id
   */
  private Long userId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

  /**
   * 仲裁调解书文件id
   */
  private String fileId;

  /**
   * 仲裁调解书文件名称
   */
  private String fileName;

}