package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 保存司法确认申请书请求参数
 * @Author: caiwei
 * @Date: Created 2018-08-10
 */
@Data
public class SaveJudicialConfirmBookReqDTO implements Serializable {

  private static final long serialVersionUID = -5277323215271229124L;

  /**
   * 司法确认申请书id
   */
  private Long judicialConfirmBookId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方
   */
  private List<DocPersonReqDTO> personList;

  /**
   * 请求事项
   */
  private String requestContent;

  /**
   * 扩展字段
   */
  private String extendJson;

  /**
   * 创建者id
   */
  private Long createId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

}
