package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存调解协议书请求实体
 * @Author: caiwei
 * @Date: 2019/3/1
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SaveMediationBookReqDTO implements Serializable {

  private static final long serialVersionUID = 6954300512268481649L;

  /**
   * 调解协议书id
   */
  private Long mediationBookId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 编号
   */
  private String caseNo;
  
  /**
   * 机构Id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 调解协议人员
   */
  private List<DocPersonReqDTO> mediationBookPersonList;

  /**
   * 纠纷主要事实，争议事项
   */
  private String disputeContent;

  /**
   * 经调解，自愿达成如下协议
   */
  private String mediationContent;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

  /**
   * 协助调解员
   */
  List<MediatorHelpPersonReqDTO> helpList;

}