package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存无异议调解方案请求实体
 * @Author: caiwei
 * @Date: 2019/3/4
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SaveMediationSchemeReqDTO implements Serializable {

  private static final long serialVersionUID = 6954300512268481649L;

  /**
   * 无异议调解方案id
   */
  private Long mediationSchemeId;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 编号
   */
  private String caseNo;

  /**
   * 机构ID
   */
  private Long orgId;
  
  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 无异议调解方案人员
   */
  private List<DocPersonReqDTO> mediationSchemePersonList;

  /**
   * 调解方案
   */
  private String mediationScheme;

  /**
   * 调解须知
   */
  private String mediationNeeds;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

  /**
   * 协助调解员
   */
  List<MediatorHelpPersonReqDTO> helpList;

}