package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 保存承诺书请求参数
 * @Author: caiwei
 * @Date: Created 2019-03-04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SavePromiseBookReqDTO implements Serializable {

  private static final long serialVersionUID = 8003305463345753375L;

  /**
   * 调解室id/案件id
   */
  private Long objectId;

  /**
   * 调解室/案件
   */
  private String objectType;

  /**
   * 调解结构ID
   */
  private Long orgId;
  
  /**
   * 调解结构
   */
  private String orgName;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请方承诺内容
   */
  private String applicantContent;

  /**
   * 被申请方承诺内容
   */
  private String respondentContent;

  /**
   * 承诺书人员
   */
  private List<DocPersonReqDTO> personList;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;
}
