package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 分享文书请求实体
 * @author ljf
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
public class ShareDocReqDTO implements Serializable {

  public ShareDocReqDTO(@NotNull(message = "案件空间id不可为空") Long bizRoomId,
      @NotNull(message = "分享目标在线庭审id不可为空") Long meetingId, List<Long> docAttachmentIdList) {
    super();
    this.bizRoomId = bizRoomId;
    this.meetingId = meetingId;
    this.docAttachmentIdList = docAttachmentIdList;
  }

  @NotNull(message = "案件空间id不可为空")
  private Long bizRoomId;
  @NotNull(message = "分享目标在线庭审id不可为空")
  private Long meetingId;

  private List<Long> docAttachmentIdList;
  
  private List<Long> docIdList;
}
