package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;
import com.beiming.odr.document.enums.DocMsgSendTypeEnum;

/**
 * 签名请求的基础信息参数
 * 
 * @author DJQ
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureBizInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotEmpty(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL)
  private Long docId; // 文书ID

  @NotEmpty(message = DocumentValidateMessage.PARAMETER_BIZ_ID_NULL)
  private Long bizId; // 业务主体ID

  @NotEmpty(message = DocumentValidateMessage.PARAMETER_BIZ_TYPE_NULL)
  private String bizType; // 业务主体类型

  /**
   * 业务主体的编号（注意：不是文书里的编号）
   */
  private String bizNo;
  /**
   * 业务主体的纠纷类型（注意：不是文书里的纠纷类型）
   */
  private String bizDisputeType;
  /**
   * 短信开关
   * 
   * @see DocMsgSendTypeEnum
   */
  private String msgSwitch;

}
