package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 签名确认结果信息参数
 *
 * @author chenjt 2019-01-285
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureConfirmInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -8433803681683752785L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId; // 用户ID
  @NotNull(message = DocumentValidateMessage.PARAMETER_DOC_ID_NULL)
  private List<Long> documentIds; // 文书ID


}
