package com.beiming.odr.document.dto.requestdto;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.document.DocumentValidateMessage;

/**
 * 签名请求的基础信息参数
 * 
 * @author DJQ
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotNull(message = DocumentValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId; // 用户ID

  @NotNull(message = DocumentValidateMessage.PARAMETER_IMG_ID_NULL)
  private String imgId; // 图像文件ID

  @NotNull(message = DocumentValidateMessage.PARAMETER_IMG_DEGREE_NULL)
  private Integer degree; // 旋转度数90，180，270

  @NotEmpty(message = DocumentValidateMessage.PARAMETER_BIZ_INFO_NULL)
  private List<SignatureBizInfoReqDTO> signBizInfo; // 业务信息
  
  private List<SignatureUserReqDTO> userAndImg;

  // 笔录意见
  private String docOpinion;

  public SignatureInfoReqDTO(SignatureInfoReqDTO signInfoReq, @NotEmpty(
      message = DocumentValidateMessage.PARAMETER_BIZ_INFO_NULL) List<SignatureBizInfoReqDTO> signBizInfo) {
    super();
    this.userId = signInfoReq.getUserId();
    this.degree = signInfoReq.getDegree();
    this.imgId = signInfoReq.getImgId();
    this.signBizInfo = signBizInfo;
  }

  public SignatureInfoReqDTO(Long userId, String imgId, Integer degree,
      List<SignatureBizInfoReqDTO> signBizInfo) {
    super();
    this.userId = userId;
    this.degree = degree;
    this.imgId = imgId;
    this.signBizInfo = signBizInfo;
  }

  public SignatureInfoReqDTO(@Valid SignatureInfoReqDTO signInfoReq, @NotNull(
      message = DocumentValidateMessage.PARAMETER_BIZ_INFO_NULL) SignatureBizInfoReqDTO bizInfo) {
    this.userId = signInfoReq.getUserId();
    this.degree = signInfoReq.getDegree();
    this.imgId = signInfoReq.getImgId();
    this.signBizInfo = Arrays.asList(bizInfo);
    this.docOpinion = signInfoReq.getDocOpinion();
  }

}
